/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__PARTNER_H
#define MX__PARTNER_H

#include "mx__lib_types.h"
#include "mx__valgrind.h"

/*************
 * Partner stuff
 */

#define MX_UNKNOWN_SRC_PEER_INDEX -1
#define MX__QUADRANT_ONE (MX__SEQNO_CNT / 4U)
#define MX__QUADRANT(seq) (MX__SEQNO(seq) / MX__QUADRANT_ONE)
#define MX__SEQNO(seq) ((seq) & (MX__SEQNO_CNT -1U))
#define MX__SESNO(seq) ((seq) & (0x10000U - MX__SEQNO_CNT))
#define MX__SESNO_ONE MX__SEQNO_CNT

void mx__partner_cleanup(struct mx_endpoint *ep, struct mx__partner *partner, int disconnect);

struct mx__partner * mx__partner_create(struct mx_endpoint *ep, uint16_t peer_index, uint16_t endpt);

static inline
struct mx__partner *
mx__endpoint_lookup_partner(struct mx_endpoint *ep,
			    uint16_t source_endpt,
			    uint16_t source_lookup_hint)
{
  int idx = source_endpt +  source_lookup_hint * ep->max_endpoints;
  if (unlikely(ep->remote_ep[idx] == NULL)) {
    ep->remote_ep[idx] = mx__partner_create(ep, source_lookup_hint, source_endpt);
  }
  return ep->remote_ep[idx];
}

/* negative if msg has already been seen,
   zero if msg is the current expected one,
   positive if msg is early */
static inline int16_t
mx__msg_order(uint16_t msg_seq, uint16_t cur_seq)
{
  if (msg_seq == cur_seq)
    return 0;
  /* make sure we return < 0 if msg_seq != cur_seq */
  return ((int16_t)(msg_seq - cur_seq) << 2) | (MX__SESNO(msg_seq ^ cur_seq)? (int16_t)-1 : (int16_t)0);
}

struct mx__early *
mx__partner_insert_early(struct mx__partner *partner, mcp_uevt_msg_t *xyz,
			 uint16_t msg_seq, mx__process_recv_msg_t recv_func,
			 uint8_t type, char *data);

static inline struct mx__partner *
mx__partner_from_addr(mx_endpoint_addr_t * addr)
{
  return *(struct mx__partner **) addr;
}

static inline void
mx__partner_to_addr(struct mx__partner * partner, mx_endpoint_addr_t * addr)
{
  *(struct mx__partner **) addr = partner;
  MX_VALGRIND_MEMORY_MAKE_READABLE(addr, sizeof(*addr));
}

void mx__print_partner(struct mx__partner *partner);

/**************
 * Early stuff
 */

#define MX__EARLY_FROM_QUEUE_ELT(x)		\
 ((struct mx__early *)				\
  (((char*) x)					\
   - offsetof(struct mx__early, queue_elt)))

static inline void
mx__partner_init_early_queue(struct mx__partner * partner)
{
  partner->early_queue.next = partner->early_queue.prev = &partner->early_queue;
}

#define mx__isempty_partner_early_queue(p) ((p)->early_queue.next == &(p)->early_queue)

static inline struct mx__early *
mx__partner_first_early(struct mx__partner * partner)
{
  mx_assert(!mx__isempty_partner_early_queue(partner));
  return MX__EARLY_FROM_QUEUE_ELT(partner->early_queue.next);
}

static inline void
mx__partner_insert_early_after(struct mx__partner * partner,
			       struct mx__early *new, struct mx__early *old)
{
    new->queue_elt.prev = old->queue_elt.prev;
    new->queue_elt.next = &old->queue_elt;
    new->queue_elt.prev->next = &new->queue_elt;
    new->queue_elt.next->prev = &new->queue_elt;
}

static inline void
mx__partner_drop_early(struct mx__early *early)
{
  early->queue_elt.prev->next = early->queue_elt.next;
  early->queue_elt.next->prev = early->queue_elt.prev;
  if (early->data)
    mx_free(early->data);
  mx_free(early);
}

#define MX__FOREACH_PARTNER_EARLY(early, elt, partner)				\
for(elt = partner->early_queue.next, early = MX__EARLY_FROM_QUEUE_ELT(elt);	\
    elt != &partner->early_queue;						\
    elt = elt->next, early = MX__EARLY_FROM_QUEUE_ELT(elt))

#endif
